<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => '/home/cp920696/public_html/thebestiso.com/templates/jl_copious_pro/custom/particles/member.yaml',
    'modified' => 1492490682,
    'data' => [
        'name' => 'Member',
        'description' => 'Member.',
        'type' => 'particle',
        'icon' => 'fa-users',
        'form' => [
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable Tabs particles.',
                    'default' => true
                ],
                'tabs' => [
                    'type' => 'container.tabs',
                    'fields' => [
                        'tab_general' => [
                            'label' => 'General Setting',
                            'fields' => [
                                'slide' => [
                                    'type' => 'select.select',
                                    'label' => 'Slide type',
                                    'description' => 'Select the slide type.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'slider' => 'Slider',
                                        'slideset' => 'Slideset'
                                    ]
                                ],
                                'style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Select the style.',
                                    'default' => 0,
                                    'options' => [
                                        0 => 'Default',
                                        1 => 'Style 1',
                                        2 => 'Style 2',
                                        3 => 'Style 3',
                                        4 => 'Style 4',
                                        5 => 'Style 5'
                                    ]
                                ],
                                'columns' => [
                                    'type' => 'select.select',
                                    'label' => 'Columns',
                                    'description' => 'Set the number item on a row.',
                                    'default' => 4,
                                    'options' => [
                                        1 => 1,
                                        2 => 2,
                                        3 => 3,
                                        4 => 4,
                                        5 => 5,
                                        6 => 6
                                    ]
                                ],
                                'autoplay' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Autoplay',
                                    'description' => 'Defines whether or not the slider items should switch automatically.',
                                    'default' => true
                                ],
                                'pause' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Pause On Hover',
                                    'description' => 'Pause autoplay when hovering a slider.',
                                    'default' => true
                                ],
                                'interval' => [
                                    'type' => 'input.number',
                                    'label' => 'Interval',
                                    'description' => 'Defines the timespan between switching slide items (millisecond).',
                                    'default' => 7000
                                ],
                                'slidenav' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Arrows Navigation',
                                    'description' => 'Show arrows navigation.',
                                    'default' => true
                                ],
                                'dotnav' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Dots Navigation',
                                    'description' => 'Show dots navigation.',
                                    'default' => false
                                ],
                                'gutter' => [
                                    'type' => 'select.select',
                                    'label' => 'Gutter',
                                    'description' => 'Add some spacing between items.',
                                    'default' => 'uk-grid-medium',
                                    'options' => [
                                        'uk-grid-collapse' => 'Collapse',
                                        'uk-grid-small' => 'Small',
                                        'uk-grid-medium' => 'Medium',
                                        'uk-grid-large' => 'Large'
                                    ]
                                ]
                            ]
                        ],
                        'tab_slider' => [
                            'label' => 'Slider Setting',
                            'fields' => [
                                'tutorial' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => '<center>This setting only apply to Slider type.</center>'
                                ],
                                'slider.center' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Center mode',
                                    'description' => 'Center items mode.',
                                    'default' => false
                                ],
                                'slider.infinite' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Infinite',
                                    'description' => 'Infinite scrolling.',
                                    'default' => true
                                ]
                            ]
                        ],
                        'tab_slideset' => [
                            'label' => 'Slideset Setting',
                            'fields' => [
                                'tutorial' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => '<center>This setting only apply to Slideset type.</center>'
                                ],
                                'slideset.animation' => [
                                    'type' => 'select.select',
                                    'label' => 'Animation',
                                    'description' => 'Select the animation.',
                                    'default' => 'fade',
                                    'options' => [
                                        'fade' => 'Fade',
                                        'scale' => 'Scale',
                                        'slide-horizontal' => 'Slide Horizontal',
                                        'slide-vertical' => 'Slide Vertical',
                                        'slide-top' => 'Slide Top',
                                        'slide-bottom' => 'Slide Bottom'
                                    ]
                                ],
                                'slideset.duration' => [
                                    'type' => 'input.number',
                                    'label' => 'Animation duration.',
                                    'description' => 'Defines the transition duration(ms).',
                                    'default' => 200
                                ]
                            ]
                        ],
                        'tab_item' => [
                            'label' => 'List items',
                            'fields' => [
                                'items' => [
                                    'type' => 'collection.list',
                                    'array' => true,
                                    'label' => 'Items',
                                    'description' => 'Testimonial Items',
                                    'value' => 'title',
                                    'ajax' => true,
                                    'fields' => [
                                        '.class' => [
                                            'type' => 'input.selectize',
                                            'label' => 'CSS Classes',
                                            'description' => 'CSS class name for the item.',
                                            'default' => NULL
                                        ],
                                        '.memberimg' => [
                                            'type' => 'input.imagepicker',
                                            'label' => 'Member Image',
                                            'description' => 'Select member image.'
                                        ],
                                        '.membername' => [
                                            'type' => 'input.text',
                                            'label' => 'Member Name',
                                            'description' => 'Enter member name.'
                                        ],
                                        '.memberrole' => [
                                            'type' => 'input.text',
                                            'label' => 'Member Role',
                                            'description' => 'Enter member role(custom html here).'
                                        ],
                                        '.memberdescription' => [
                                            'type' => 'textarea.textarea',
                                            'label' => 'Member Description',
                                            'description' => 'Enter member description(custom html here).'
                                        ],
                                        '.membericon' => [
                                            'type' => 'collection.list',
                                            'array' => true,
                                            'label' => 'Member SubItem',
                                            'description' => 'Create a list of subitem link to social or website.',
                                            'value' => 'name',
                                            'ajax' => true,
                                            'fields' => [
                                                '.icon' => [
                                                    'type' => 'input.icon',
                                                    'label' => 'Member Icon',
                                                    'description' => 'Select icon.'
                                                ],
                                                '.link' => [
                                                    'type' => 'input.text',
                                                    'label' => 'Link',
                                                    'description' => 'Enter link.'
                                                ]
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ]
                ],
                'class' => [
                    'type' => 'input.selectize',
                    'label' => 'CSS Classes',
                    'description' => 'CSS class name for the particle.'
                ],
                'copyright' => [
                    'type' => 'separator.note',
                    'class' => 'alert alert-info',
                    'content' => 'Developed and maintained by <a href="https://www.joomlead.com/" target="_blank">JoomLead.com</a><br><strong>Version: 1.0.1</strong>'
                ]
            ]
        ]
    ]
];
