<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => '/home/cp920696/public_html/thebestiso.com/templates/jl_copious_pro/custom/particles/joomlacontent.yaml',
    'modified' => 1492151500,
    'data' => [
        'name' => 'Joomla Content',
        'description' => 'Display Joomla Content.',
        'type' => 'particle',
        'icon' => 'fa-joomla',
        'form' => [
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable Joomla Articles particles.',
                    'default' => true
                ],
                '_tabs' => [
                    'type' => 'container.tabs',
                    'fields' => [
                        'tab_general' => [
                            'label' => 'General',
                            'fields' => [
                                'slide' => [
                                    'type' => 'select.select',
                                    'label' => 'Slide type',
                                    'description' => 'Select the slide type.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'slider' => 'Slider',
                                        'slideset' => 'Slideset'
                                    ]
                                ],
                                'style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Select the style.',
                                    'default' => 'Style 1',
                                    'options' => [
                                        0 => 'Default',
                                        1 => 'Style 1'
                                    ]
                                ],
                                'columns' => [
                                    'type' => 'select.select',
                                    'label' => 'Columns',
                                    'description' => 'Set the number item on a row.',
                                    'default' => 4,
                                    'options' => [
                                        1 => 1,
                                        2 => 2,
                                        3 => 3,
                                        4 => 4,
                                        5 => 5,
                                        6 => 6
                                    ]
                                ],
                                'autoplay' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Autoplay',
                                    'description' => 'Defines whether or not the slider items should switch automatically.',
                                    'default' => true
                                ],
                                'pause' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Pause On Hover',
                                    'description' => 'Pause autoplay when hovering a slider.',
                                    'default' => true
                                ],
                                'interval' => [
                                    'type' => 'input.number',
                                    'label' => 'Interval',
                                    'description' => 'Defines the timespan between switching slide items (millisecond).',
                                    'default' => 7000
                                ],
                                'slidenav' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Arrows Navigation',
                                    'description' => 'Show arrows navigation.',
                                    'default' => true
                                ],
                                'dotnav' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Dots Navigation',
                                    'description' => 'Show dots navigation.',
                                    'default' => false
                                ],
                                'gutter' => [
                                    'type' => 'select.select',
                                    'label' => 'Gutter',
                                    'description' => 'Add some spacing between items.',
                                    'default' => 'uk-grid-medium',
                                    'options' => [
                                        'uk-grid-collapse' => 'Collapse',
                                        'uk-grid-small' => 'Small',
                                        'uk-grid-medium' => 'Medium',
                                        'uk-grid-large' => 'Large'
                                    ]
                                ]
                            ]
                        ],
                        'tab_slider' => [
                            'label' => 'Slider',
                            'fields' => [
                                'tutorial' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => '<center>This setting only apply to Slider type.</center>'
                                ],
                                'slider.center' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Center mode',
                                    'description' => 'Center items mode.',
                                    'default' => false
                                ],
                                'slider.infinite' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Infinite',
                                    'description' => 'Infinite scrolling.',
                                    'default' => true
                                ]
                            ]
                        ],
                        'tab_slideset' => [
                            'label' => 'Slideset',
                            'fields' => [
                                'tutorial' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => '<center>This setting only apply to Slideset type.</center>'
                                ],
                                'slideset.animation' => [
                                    'type' => 'select.select',
                                    'label' => 'Animation',
                                    'description' => 'Select the animation.',
                                    'default' => 'fade',
                                    'options' => [
                                        'fade' => 'Fade',
                                        'scale' => 'Scale',
                                        'slide-horizontal' => 'Slide Horizontal',
                                        'slide-vertical' => 'Slide Vertical',
                                        'slide-top' => 'Slide Top',
                                        'slide-bottom' => 'Slide Bottom'
                                    ]
                                ],
                                'slideset.duration' => [
                                    'type' => 'input.number',
                                    'label' => 'Animation duration.',
                                    'description' => 'Defines the transition duration(ms).',
                                    'default' => 200
                                ]
                            ]
                        ],
                        '_tab_articles' => [
                            'label' => 'Articles',
                            'overridable' => false,
                            'fields' => [
                                'article.filter.categories' => [
                                    'type' => 'joomla.categories',
                                    'label' => 'Categories',
                                    'description' => 'Select the categories the articles should be taken from. This will be ignored if you set articles id below.',
                                    'overridable' => false
                                ],
                                'article.filter.articles' => [
                                    'type' => 'input.text',
                                    'label' => 'Articles',
                                    'description' => 'Enter the Joomla articles that should be shown. It should be a list of article IDs separated with a comma (i.e. 1,2,3,4,5).',
                                    'overridable' => false
                                ],
                                'article.filter.featured' => [
                                    'type' => 'select.select',
                                    'label' => 'Featured Articles',
                                    'description' => 'Select how Featured articles should be filtered.',
                                    'default' => '',
                                    'options' => [
                                        'include' => 'Include Featured',
                                        'exclude' => 'Exclude Featured',
                                        'only' => 'Only Featured'
                                    ],
                                    'overridable' => false
                                ],
                                'article.limit.total' => [
                                    'type' => 'input.text',
                                    'label' => 'Number of Articles',
                                    'description' => 'Enter the maximum number of articles to display.',
                                    'default' => 2,
                                    'pattern' => '\\d{1,2}',
                                    'overridable' => false
                                ],
                                'article.limit.start' => [
                                    'type' => 'input.text',
                                    'label' => 'Start From',
                                    'description' => 'Enter offset specifying the first article to return. The default is \'0\' (the first article).',
                                    'default' => 0,
                                    'pattern' => '\\d{1,2}',
                                    'overridable' => false
                                ],
                                'article.sort.orderby' => [
                                    'type' => 'select.select',
                                    'label' => 'Order By',
                                    'description' => 'Select how the articles should be ordered by.',
                                    'default' => 'publish_up',
                                    'options' => [
                                        'publish_up' => 'Published Date',
                                        'created' => 'Created Date',
                                        'modified' => 'Last Modified Date',
                                        'title' => 'Title',
                                        'ordering' => 'Ordering',
                                        'hits' => 'Hits',
                                        'id' => 'ID',
                                        'alias' => 'Alias'
                                    ],
                                    'overridable' => false
                                ],
                                'article.sort.ordering' => [
                                    'type' => 'select.select',
                                    'label' => 'Ordering Direction',
                                    'description' => 'Select the direction the articles should be ordered by.',
                                    'default' => 'ASC',
                                    'options' => [
                                        'ASC' => 'Ascending',
                                        'DESC' => 'Descending'
                                    ],
                                    'overridable' => false
                                ]
                            ]
                        ],
                        '_tab_display' => [
                            'label' => 'Display',
                            'fields' => [
                                'article.display.image.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Image',
                                    'description' => 'Select if and what image of the article should be shown.',
                                    'default' => 'intro',
                                    'options' => [
                                        'intro' => 'Intro',
                                        'full' => 'Full',
                                        '' => 'None'
                                    ]
                                ],
                                'article.display.text.type' => [
                                    'type' => 'select.select',
                                    'label' => 'Article Text',
                                    'description' => 'Select if and how the article text should be shown.',
                                    'default' => 'intro',
                                    'options' => [
                                        'intro' => 'Introduction',
                                        'full' => 'Full Article',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.text.limit' => [
                                    'type' => 'input.text',
                                    'label' => 'Text Limit',
                                    'description' => 'Type in the number of characters the article text should be limited to.',
                                    'default' => '',
                                    'pattern' => '\\d+'
                                ],
                                'article.display.text.formatting' => [
                                    'type' => 'select.select',
                                    'label' => 'Text Formatting',
                                    'description' => 'Select the formatting you want to use to display the article text.',
                                    'default' => 'text',
                                    'options' => [
                                        'text' => 'Plain Text',
                                        'html' => 'HTML'
                                    ]
                                ],
                                'article.display.title.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Title',
                                    'description' => 'Select if the article title should be shown.',
                                    'default' => 'show',
                                    'options' => [
                                        'show' => 'Show',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.title.limit' => [
                                    'type' => 'input.text',
                                    'label' => 'Title Limit',
                                    'description' => 'Enter the maximum number of characters the article title should be limited to.',
                                    'pattern' => '\\d+(\\.\\d+){0,1}'
                                ],
                                'article.display.date.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Date',
                                    'description' => 'Select if the article date should be shown.',
                                    'default' => 'published',
                                    'options' => [
                                        'created' => 'Show Created Date',
                                        'published' => 'Show Published Date',
                                        'modified' => 'Show Modified Date',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.date.format' => [
                                    'type' => 'select.date',
                                    'label' => 'Date Format',
                                    'description' => 'Select preferred date format. Leave empty not to display a date.',
                                    'default' => 'l, F d, Y',
                                    'selectize' => [
                                        'allowEmptyOption' => true
                                    ],
                                    'options' => [
                                        'l, F d, Y' => 'Date1',
                                        'l, d F' => 'Date2',
                                        'D, d F' => 'Date3',
                                        'F d' => 'Date4',
                                        'd F' => 'Date5',
                                        'd M' => 'Date6',
                                        'D, M d, Y' => 'Date7',
                                        'D, M d, y' => 'Date8',
                                        'l' => 'Date9',
                                        'l j F Y' => 'Date10',
                                        'j F Y' => 'Date11'
                                    ]
                                ],
                                'article.display.read_more.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Read More',
                                    'description' => 'Select if the article \'Read More\' button should be shown.',
                                    'default' => 'show',
                                    'options' => [
                                        'show' => 'Show',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.read_more.label' => [
                                    'type' => 'input.text',
                                    'label' => 'Read More Label',
                                    'description' => 'Type in the label for the \'Read More\' button.',
                                    'placeholder' => 'Read More...'
                                ],
                                'article.display.read_more.css' => [
                                    'type' => 'input.selectize',
                                    'label' => 'Button CSS Classes',
                                    'description' => 'CSS class name for the \'Read More\' button.'
                                ],
                                'article.display.author.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Author',
                                    'description' => 'Select if the article author should be shown.',
                                    'default' => 'show',
                                    'options' => [
                                        'show' => 'Show',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.category.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Category',
                                    'description' => 'Select if and how the article category should be shown.',
                                    'default' => 'link',
                                    'options' => [
                                        'show' => 'Show',
                                        'link' => 'Show with Link',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.hits.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Hits',
                                    'description' => 'Select if the article hits should be shown.',
                                    'default' => 'show',
                                    'options' => [
                                        'show' => 'Show',
                                        '' => 'Hide'
                                    ]
                                ]
                            ]
                        ],
                        'tab_template' => [
                            'label' => 'Template',
                            'fields' => [
                                'tutorial' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => '<center>You can overide all the default content with your custom template.<br>To use template, simply write html code and use variable like %variable%. This code will be used for EACH article which displayed and variable will be replaced by articles content. You can use the following variable:</center>%articleImage% = Article image.<br>%articleLink% = Link to the article.<br>%articleTitle% = Article title.<br>%articleDate% = Article created/published/modified date (depend on your setting).<br>%articleAuthor% = Article Author.<br>%articleCategoryLink% = Link to the category.<br>%articleCategoryTitle% = Category Name.<br>%articleHits% = Article Hit.<br>%articleText% = Article Content.<br>%articleReadmore% = Article Readmore Button<br>Below is our default template.'
                                ],
                                'template.enabled' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Enable',
                                    'description' => 'Enable custom template and overide all default content.',
                                    'default' => false
                                ],
                                'template.content' => [
                                    'type' => 'textarea.textarea',
                                    'label' => 'Template content',
                                    'description' => 'Enter custom template content.',
                                    'default' => '<div class="jl-content-item">
	<div class="jl-content-item-container uk-grid uk-grid-margin">
	
		<div class="jl-content-item-image uk-width-1-1">
             <a href="%articleLink%">
                 %articleImage%
             </a>
         </div>
		 <div class="jl-content-item-title uk-width-1-1">
              <h3 class="jl-content-item-title">
				<a href="%articleRoute%">
                  %articleTitle%
				</a>
              </h3>
         </div>
		 
		 <div class="jl-content-item-details">
			<span class="jl-content-item-date">
                <i class="fa fa-clock-o" aria-hidden="true"></i>
                %articleDate%
            </span>
			<span class="jl-content-item-author">
                <i class="fa fa-user" aria-hidden="true"></i>
                %articleAuthor%
            </span>
			<span class="jl-content-item-category">
				<a href="%articleCategoryLink%">
                   <i class="fa fa-folder-open" aria-hidden="true"></i>
				   %articleCategoryTitle%
                </a>
			</span>
			<span class="jl-content-item-hits">
				<i class="fa fa-eye" aria-hidden="true"></i>
				%articleHits%
			</span>
		 </div>
		 <div class="jl-content-item-text uk-width-1-1">
            %articleText%
         </div>
		 <div class="jl-content-item-read-more">
            <a href="{{ article.route }}">
              %articleReadmore%
            </a>
         </div>
	</div>
</div>'
                                ]
                            ]
                        ]
                    ]
                ],
                'class' => [
                    'type' => 'input.selectize',
                    'label' => 'CSS Classes',
                    'description' => 'CSS class name for the particle.'
                ],
                'copyright' => [
                    'type' => 'separator.note',
                    'class' => 'alert alert-info',
                    'content' => 'Developed and maintained by <a href="https://www.joomlead.com/" target="_blank">JoomLead.com</a><br><strong>Version: 1.0.1</strong>'
                ]
            ]
        ]
    ]
];
