<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => '/home/cp920696/public_html/thebestiso.com/templates/jl_copious_pro/custom/particles/overlayslider.yaml',
    'modified' => 1480032980,
    'data' => [
        'name' => 'Overlay Slider',
        'description' => 'Overlay Slider.',
        'type' => 'particle',
        'icon' => 'fa-file-image-o',
        'form' => [
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable to the particles.',
                    'default' => true
                ],
                'numberitem' => [
                    'type' => 'select.select',
                    'label' => 'Number Item on Row',
                    'description' => 'Select the number item on row.',
                    'default' => 3,
                    'options' => [
                        1 => 1,
                        2 => 2,
                        3 => 3,
                        4 => 4,
                        5 => 5
                    ]
                ],
                'bgoverlay' => [
                    'type' => 'input.colorpicker',
                    'label' => 'Overlay Background',
                    'description' => 'Customize the color background overlay'
                ],
                'slidestyle' => [
                    'type' => 'select.select',
                    'label' => 'Slide Style',
                    'description' => 'Select the slider style',
                    'default' => 'Slide Nav',
                    'options' => [
                        1 => 'Slide nav',
                        2 => 'Dotnav'
                    ]
                ],
                'autoplay' => [
                    'type' => 'select.select',
                    'label' => 'Autoplay',
                    'description' => 'Defines whether or not the slider items should switch automatically',
                    'default' => 'Yes',
                    'options' => [
                        1 => 'Yes',
                        0 => 'No'
                    ]
                ],
                'slideanimation' => [
                    'type' => 'select.select',
                    'label' => 'Slide Animations',
                    'description' => 'Select the slide animation.',
                    'default' => 'Fade',
                    'options' => [
                        'fade' => 'Fade',
                        'scale' => 'Slider Bottom',
                        'slide-horizontal' => 'Slider Horizontal',
                        'slide-vertical' => 'Slider Vertical',
                        'slide-top' => 'Slide Top',
                        'slide-bottom' => 'Slide Bottom'
                    ]
                ],
                'animation' => [
                    'type' => 'select.select',
                    'label' => 'Overlay Animations',
                    'description' => 'Select the overlay animation.',
                    'default' => 'Slider Top',
                    'options' => [
                        'uk-overlay-slide-top' => 'Slider Top',
                        'uk-overlay-slide-bottom' => 'Slider Bottom',
                        'uk-overlay-slide-left' => 'Slider Left',
                        'uk-overlay-slide-right' => 'Slider Right',
                        'uk-overlay-fade' => 'Fade',
                        'uk-overlay-scale' => 'Scale',
                        'uk-overlay-spin' => 'Spin'
                    ]
                ],
                'horizontal' => [
                    'type' => 'select.select',
                    'label' => 'Horizontal align',
                    'description' => 'Select the horizontal align.',
                    'default' => 'Center',
                    'options' => [
                        'uk-flex-left' => 'Left',
                        'uk-flex-right' => 'Right',
                        'uk-flex-center' => 'Center'
                    ]
                ],
                'vertical' => [
                    'type' => 'select.select',
                    'label' => 'Vertical align',
                    'description' => 'Select the vertical align.',
                    'default' => 'Middle',
                    'options' => [
                        'uk-flex-top' => 'Top',
                        'uk-flex-middle' => 'Middle',
                        'uk-flex-bottom' => 'Bottom'
                    ]
                ],
                'items' => [
                    'type' => 'collection.list',
                    'array' => true,
                    'label' => 'Items',
                    'description' => 'Create each tab to display.',
                    'value' => 'name',
                    'ajax' => true,
                    'fields' => [
                        '.image' => [
                            'type' => 'input.imagepicker',
                            'label' => 'Image',
                            'description' => 'Select the main image.'
                        ],
                        '.title' => [
                            'type' => 'input.text',
                            'label' => 'Title',
                            'description' => 'Customize the title'
                        ],
                        '.link' => [
                            'type' => 'input.text',
                            'label' => 'Link',
                            'description' => 'Customize the link'
                        ],
                        '.class' => [
                            'type' => 'input.selectize',
                            'label' => 'CSS Classes',
                            'description' => 'CSS class name for the particle.',
                            'default' => NULL
                        ]
                    ]
                ]
            ]
        ]
    ]
];
